package com.aotter.net.controller.error

import com.aotter.net.dto.error.request.ErrorReport
import com.aotter.net.dto.trek.request.AdBo
import com.aotter.net.dto.trek.response.TrekNativeAdDto
import com.aotter.net.model.repository.error.ErrorReportRepository
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.launch

class ErrorReportController(
    private val errorReportRepository: ErrorReportRepository
) {

    private val TAG: String = ErrorReportController::class.java.simpleName

    private val scope: CoroutineScope by lazy {
        CoroutineScope(Dispatchers.Main + SupervisorJob())
    }

    fun postError(errorReport: ErrorReport<AdBo, TrekNativeAdDto>) = scope.launch {

        errorReportRepository.postError(errorReport).onEach { _ ->

        }.launchIn(this)

    }

}