package com.aotter.net.dto

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement


@Serializable
data class User(
    val birthday: String = "",
    var email: String = "",
    val fbId: String = "",
    val gender: String = "",
    var phone: String = "",
    val meta: TrekJsonObject = TrekJsonObject(),
    var fpId: String = "",
) {
    private var eidsItems: List<EidsItem> = mutableListOf()

    fun setEidsItems(list: List<EidsItem>) {
        eidsItems = list
    }
}

@Serializable
data class EidsItem(
    @SerialName("uids")
    val uids: MutableList<Uid> = mutableListOf(),
    @SerialName("source")
    val source: String = ""
)

@Serializable
data class Uid(
    @SerialName("id")
    val id: String = "",
    @SerialName("ext")
    val ext: Map<String, JsonElement>?
)

