package com.aotter.net.dto.eids.response

import com.aotter.net.trek.sealed.EidsRemoveByType
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
data class UserEids(
    @SerialName("eid_type")
    val eidType: String,
    @SerialName("source")
    val source: String,
    @SerialName("hashed_email")
    val hashedEmail: String?,
    @SerialName("hashed_phone")
    val hashedPhone: String?,
    @SerialName("advertising_token")
    val advertisingToken: String,
    @SerialName("refresh_token")
    val refreshToken: String?,
    @SerialName("identity_expires")
    val identityExpires: Long?,
    @SerialName("refresh_from")
    val refreshFrom: Long?,
    @SerialName("refresh_expires")
    val refreshExpires: Long?,
    @SerialName("refresh_key")
    val refreshKey: String?,
    @SerialName("remove_by")
    val removeBy: List<String?>?,
    @SerialName("ext")
    val ext: Map<String, JsonElement>?,
) {

    fun needRemove(types: List<EidsRemoveByType>): Boolean {
        val list = removeBy ?: emptyList()
        val typesSet = types.map { it.type }.toSet()
        return list.intersect(typesSet).isNotEmpty()
    }

    fun needRefresh(now: Long): Boolean {
        val time = refreshFrom ?: 0
        return time < now
    }

    fun identityTimeout(now: Long): Boolean {
        val time = identityExpires ?: 0
        return time < now
    }

    fun refreshTimeout(now: Long): Boolean {
        val time = refreshExpires ?: 0
        return time < now
    }
}
