package com.aotter.net.dto.trek.request

import com.aotter.net.dto.Device
import com.aotter.net.dto.TrekJsonObject
import com.aotter.net.dto.User
import kotlinx.serialization.Serializable

@Serializable
data class AdBo(
    val device: Device,
    val user: User,
    val sdkVersion: String,
    val sdkVersionCode: Int,
    val mediationVersion: String,
    val mediationVersionCode: Int,
    val placeUid: String,
    val payload: Payload,
    val sspDomain: String? = "",
    val sspPathFetchAd: String? = "",
    val eidsDomain: String? = "",
    val eidsPathGenerate: String? = "",
    val eidsPathRefresh: String? = "",
    val trackerDomain: String? = "",
    val trackerPathReport: String? = ""
)

@Serializable
data class Payload(
    val category: String,
    val contentUrl: String,
    val contentTitle: String,
    val meta: TrekJsonObject
)
