package com.aotter.net.dto.trek.response

import kotlinx.serialization.Serializable


@Serializable
data class CatRunJavascriptInterfaceDto(
        val date: Long,
        val message: Message
)
@Serializable
data class Message(
        val action: String,
        val url_clc: String? = null,
        val payload: Payload? = null

)
@Serializable
data class Payload(
    val url: String? = "",
    val events: Events? = null,
    val preloadUrls: List<String>? = null
)
@Serializable
data class Events(
    val ACCELEROMETER: Accelerometer? = null,
    val GYROSCOPE: Gyroscope? = null,
    val PARALLAX: Parallax? = null,
    val INTERSECTION: Intersection? = null
)
@Serializable
data class Accelerometer(
        val enabled: Boolean
)
@Serializable
data class Intersection(
        val enabled: Boolean
)
@Serializable
data class Gyroscope(
        val enabled: Boolean
)
@Serializable
data class Parallax(
        val enabled: Boolean
)

