package com.aotter.net.extension

fun CharSequence?.isValidEmail(): Boolean {
    val localPartRegex = "[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*"
    val domainPartRegex = "[a-zA-Z0-9]+(?:\\.[a-zA-Z0-9]+)*(?:-[a-zA-Z0-9]+)?"
    val emailRegex = "^$localPartRegex@$domainPartRegex$"

    val customEmailPattern = Regex(emailRegex)
    return !isNullOrEmpty() && customEmailPattern.matches(this)
}


fun CharSequence?.isValidPhone(): Boolean {
    val phoneRegex = Regex("^(\\+|00|\\d{1})[0-9]{6,14}\$")
    return !this.isNullOrBlank() && phoneRegex.matches(this)
}
