package com.aotter.net.extension

import android.app.ActivityManager
import android.content.Context
import android.content.pm.ApplicationInfo
import android.content.pm.PackageInfo
import android.util.Log

fun Context.memoryCacheSizeBytes(): Int {

    val maxMemorySize = 30 * 1024 * 1024

    val activityManager = this.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager

    var memoryClass = activityManager.memoryClass

    try {

        //反射ApplicationInfo class 並拿出FLAG_LARGE_HEAP標籤
        val flagLargeHeap =
            ApplicationInfo::class.java.getDeclaredField("FLAG_LARGE_HEAP").getInt(null)

        //如果使用者app的AndroidManiFest 有加標籤 -> android:largeHeap="true" ，就替換成 largeMemoryClass
        if ((this.applicationInfo.flags and flagLargeHeap) != 0) {
            memoryClass = activityManager.largeMemoryClass
        }

    } catch (e: Exception) {
        Log.e("memoryCache", "Unable to reflectively determine large heap size.")
    }

    return maxMemorySize.coerceAtMost(memoryClass / 8 * 1024 * 1024)

}

fun Context.getVersionName(): String? {

    return try {

        val pInfo: PackageInfo = this.packageManager
            .getPackageInfo(this.packageName, 0)

        pInfo.versionName

    } catch (e: Exception) {

        ""

    }

}
