package com.aotter.net.extension

import android.graphics.drawable.BitmapDrawable
import android.view.View
import android.widget.ImageView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.ConstraintSet
import com.aotter.net.dto.trek.response.TrekNativeAd
import com.aotter.net.utils.TrekSdkSettingsUtils

fun ImageView.setImage(
    trekNativeAd: TrekNativeAd
) {

    val image = this@setImage

    image.layoutParams = ConstraintLayout.LayoutParams(
        ConstraintLayout.LayoutParams.MATCH_PARENT,
        ConstraintLayout.LayoutParams.MATCH_PARENT
    ).apply {
        bottomToBottom = ConstraintSet.PARENT_ID
        endToEnd = ConstraintSet.PARENT_ID
        startToStart = ConstraintSet.PARENT_ID
        topToTop = ConstraintSet.PARENT_ID
    }

    image.visibility = View.VISIBLE

    image.alpha = 1f

    image.scaleType = ImageView.ScaleType.FIT_XY

    TrekSdkSettingsUtils.getImageCache()[trekNativeAd.mediaSrc.backgroundPlaceHolder]?.let { backgroundHolderCache ->
        image.background = (BitmapDrawable(resources, backgroundHolderCache))
    }

    trekNativeAd.setNativeAdClickAction(this@setImage)

}