package com.aotter.net.extension

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleObserver
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

internal fun Lifecycle.addObserverExt(observer: LifecycleObserver) {

    CoroutineScope(Dispatchers.Main.immediate).launch {

        this@addObserverExt.addObserver(observer)

    }

}

internal fun Lifecycle.removeObserverExt(observer: LifecycleObserver) {

    CoroutineScope(Dispatchers.Main.immediate).launch {

        this@removeObserverExt.removeObserver(observer)

    }

}