package com.aotter.net.extension

import android.view.View
import kotlin.math.roundToInt


/**
 *  拿 View 寬的尺寸計算高(16:9)
 */
fun View.resize(containerMeasuredWidth: Int, aspectRatio: Float?) {

    if (aspectRatio == null) return

    val height = (containerMeasuredWidth * aspectRatio).roundToInt()

    val params = this.layoutParams

    params.height = height

    this.layoutParams = params

}

/**
 * 拿 server 給的建議寬高去resize
 */
fun View.resize(width: Int, height: Int) {

    if (width == 0 || height == 0) return

    val scale = context.resources.displayMetrics.density

    val w = (width * scale + 0.5f).toInt()

    val h = (height * scale + 0.5f).toInt()

    val params = this.layoutParams

    params.width = w

    params.height = h

    this.layoutParams = params

}

