package com.aotter.net.model.repository.error

import android.util.Log
import com.aotter.net.dto.error.request.ErrorReport
import com.aotter.net.dto.trek.request.AdBo
import com.aotter.net.dto.trek.response.TrekNativeAdDto
import com.aotter.net.service.error.ErrorReportService
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.flowOn
import okhttp3.ResponseBody
import retrofit2.HttpException
import java.io.IOException

class ErrorReportRepository(
    private val errorReportService: ErrorReportService
) {

    private val TAG: String = ErrorReportService::class.java.simpleName

    suspend fun postError(errorReport: ErrorReport<AdBo, TrekNativeAdDto>): Flow<ResponseBody> =
        flow<ResponseBody> {

            try {

                errorReportService.postError(errorReport)

            } catch (e: HttpException) {

                Log.i(TAG, e.localizedMessage ?: "Post error report error.")

            } catch (e: IOException) {

                Log.i(TAG, e.localizedMessage ?: "Post error report error.")

            }

        }.catch {

            Log.i(TAG, it.localizedMessage ?: "An unexpected error occurred.")

        }.flowOn(Dispatchers.IO)

}