package com.aotter.net.model.repository.tracker

import android.util.Log
import com.aotter.net.dto.tracker.request.ReportTrackerBo
import com.aotter.net.dto.tracker.response.RecordDto
import com.aotter.net.network.Resource
import com.aotter.net.service.tracker.TrackerService
import com.aotter.net.utils.TrekSdkSettingsUtils
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import retrofit2.HttpException
import java.io.IOException


class TrackerRepository(private val trackerService: TrackerService) {

    private val TAG: String = TrackerRepository::class.java.simpleName

    suspend fun postTrackerRecord(reportTrackerBo: ReportTrackerBo): Flow<Resource<RecordDto>> =
        flow {

            try {
                val record =
                    if (TrekSdkSettingsUtils.ATTrackerDomain.isNotEmpty() && TrekSdkSettingsUtils.ATTrackerPathReport.isNotEmpty()) {
                        val url =
                            "${TrekSdkSettingsUtils.ATTrackerDomain}${TrekSdkSettingsUtils.ATTrackerPathReport}"
                        trackerService.postTrackerRecord(url, reportTrackerBo)
                    } else {
                        trackerService
                            .postTrackerRecord(reportTrackerBo)
                    }

            record.success?.let {

                Log.i(TAG, "Tracker record success.")

            } ?: kotlin.run {

                Log.i(TAG, "Tracker record error.")

            }

        } catch (e: HttpException) {

            Log.i(TAG, "Tracker record error.")

        } catch (e: IOException) {

            Log.i(TAG, "Tracker record error.")

        }

    }


}