package com.aotter.net.service.eids

import com.aotter.net.dto.eids.request.EidsGenerationRequestBody
import com.aotter.net.dto.eids.request.EidsRefreshRequestBody
import com.aotter.net.dto.eids.response.UserEids
import retrofit2.http.Body
import retrofit2.http.POST
import retrofit2.http.Url

interface EidsService {

    @POST("/api/v1.0/eids/generate")
    suspend fun generate(@Body request: EidsGenerationRequestBody): ArrayList<UserEids>

    @POST("/api/v1.0/eids/refresh")
    suspend fun refresh(@Body request: EidsRefreshRequestBody): UserEids

    suspend fun generate(
        @Url url: String,
        @Body request: EidsGenerationRequestBody
    ): ArrayList<UserEids>

    suspend fun refresh(@Url url: String, @Body request: EidsRefreshRequestBody): UserEids

}