package com.aotter.net.service.trek

import com.aotter.net.dto.trek.request.AdBo
import com.aotter.net.dto.trek.response.TrekNativeAdDto
import okhttp3.ResponseBody
import retrofit2.Response
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Streaming
import retrofit2.http.Url

interface TrekService {

    @POST("/api/init")
    suspend fun init(@Body adBo: AdBo): Response<ResponseBody>

    @POST("/api/v2/fetch")
    suspend fun postAd(@Body adBo: AdBo): TrekNativeAdDto

    @POST
    suspend fun postAd(@Url url: String, @Body adBo: AdBo): TrekNativeAdDto

    @GET
    suspend fun getClickEvent(@Url url: String): Response<ResponseBody>

    @GET
    suspend fun getImpressionEvent(@Url url: String): Response<ResponseBody>

    @GET
    suspend fun getThirdPartyClickEvent(@Url url: String): Response<ResponseBody>

    @GET
    suspend fun getThirdPartyImpressionEvent(@Url url: String): Response<ResponseBody>

    @Streaming //大文件要加 不然會oom
    @GET
    suspend fun getImage(@Url url: String): Response<ResponseBody>

}