package com.aotter.net.trek.ads

class NativeAdOptions private constructor(builder: Builder) {
    private val returnUrlsForImageAssets: Boolean

    init {
        returnUrlsForImageAssets = builder.returnUrlsForImageAssets
    }

    fun shouldReturnUrlsForImageAssets(): Boolean = returnUrlsForImageAssets

    class Builder {
        var returnUrlsForImageAssets: Boolean = false
            private set

        fun setReturnUrlsForImageAssets(returnUrlsForImageAssets: Boolean): Builder {
            this.returnUrlsForImageAssets = returnUrlsForImageAssets
            return this
        }

        fun build(): NativeAdOptions = NativeAdOptions(this)
    }
}