package com.aotter.net.trek.ads

import com.aotter.net.dto.TrekJsonObject

class TrekAdRequest(private val build: Builder) {

    fun getCategory() = build.category

    fun getMeta() = build.meta

    fun getMediationVersion() = build.mediationVersion

    fun getMediationVersionCode() = build.mediationVersionCode

    fun getContentUrl() = build.contentUrl

    fun getContentTitle() = build.contentTitle

    class Builder {

        internal var category: String = ""
            get() = field

        internal var mediationVersion: String = ""
            get() = field

        internal var mediationVersionCode: Int = 0
            get() = field

        internal var contentUrl: String = ""
            get() = field

        internal var contentTitle: String = ""
            get() = field

        internal var meta: TrekJsonObject = TrekJsonObject()
            get() = field

        /**
         * 設定分類
         * @param category 分類字串
         */
        fun setCategory(category: String): Builder {

            this.category = category

            return this

        }

        /**
         * 設定內容網址
         * @param contentUrl 內容網址
         */
        fun setContentUrl(contentUrl: String): Builder {

            this.contentUrl = contentUrl

            return this

        }

        /**
         * 設定內容標題
         * @param contentTitle 內容網址
         */
        fun setContentTitle(contentTitle: String): Builder {

            this.contentTitle = contentTitle

            return this

        }

        /**
         * 客製化Meta
         * @param meta 自定義json
         */
        fun setMeta(meta: TrekJsonObject): Builder {

            this.meta = meta

            return this
        }

        fun setMediationVersion(mediationVersion: String): Builder {

            this.mediationVersion = mediationVersion

            return this

        }

        fun setMediationVersionCode(mediationVersionCode: Int): Builder {

            this.mediationVersionCode = mediationVersionCode

            return this

        }

        fun build() = TrekAdRequest(this)

    }

}