package com.aotter.net.trek.ads

import android.animation.Animator
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.constraintlayout.widget.ConstraintSet
import com.aotter.net.databinding.ViewAotterMediaBinding
import com.aotter.net.dto.trek.response.TrekNativeAd
import com.aotter.net.extension.resize
import com.aotter.net.extension.setImage
import com.aotter.net.trek.TrekDataKey
import com.aotter.net.trek.ads.base.TrekBaseView
import com.aotter.net.trek.ads.vast.AotterPlayerView
import com.aotter.net.trek.ads.webview.AotterWebView
import kotlinx.coroutines.Runnable


class TrekMediaView : TrekBaseView {

    interface TrekMediaViewListener {

        fun onLoaded(view: View) {}

    }

    private var TAG: String = TrekMediaView::class.java.simpleName

    private lateinit var viewBinding: ViewAotterMediaBinding

    private var trekMediaViewListener: TrekMediaViewListener? = null

    private var customTrekMediaViewListener: CustomTrekMediaViewListener? = null

    private var containerViewRunnable: Runnable? = null

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        init()
    }

    private fun init() {

        viewBinding = ViewAotterMediaBinding.inflate(LayoutInflater.from(context), this, true)

        viewBinding.root.layoutParams =
            LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT).apply {
                bottomToBottom = ConstraintSet.PARENT_ID
                endToEnd = ConstraintSet.PARENT_ID
                startToStart = ConstraintSet.PARENT_ID
                topToTop = ConstraintSet.PARENT_ID
            }

        //這個很重要請不要刪除
        tag = TrekDataKey.TREK_MEDIA_VIEW_TAG

        initAnimatorListener()

    }

    fun setTrekMediaViewListener(trekMediaViewListener: TrekMediaViewListener?) {

        this.trekMediaViewListener = trekMediaViewListener

    }

    fun setCustomTrekMediaViewListener(customTrekMediaViewListener: CustomTrekMediaViewListener?) {
        this.customTrekMediaViewListener = customTrekMediaViewListener
    }


    fun load(containerView: View, trekNativeAd: TrekNativeAd) {

        destroy()

        containerViewRunnable = Runnable {

            if (trekNativeAd.adType == TrekDataKey.BANNER) {

                viewBinding.root.resize(trekNativeAd.mediaSrc.width, trekNativeAd.mediaSrc.height)

            } else {

                viewBinding.root.resize(
                    containerView.measuredWidth, trekNativeAd.mediaContentAspectRatio
                )

            }

            viewBinding.backgroundHolder.setImage(trekNativeAd)

            if (trekNativeAd.isVideoAd()) {

                loadAotterPlayerView(trekNativeAd)

            } else {

                loadAotterWebView(trekNativeAd)

            }

        }.apply {

            containerView.post(this)

        }

    }

    fun destroy() {

        containerViewRunnable = null

        viewBinding.aotterPlayerView.destroy()

        viewBinding.aotterWebView.destroy()

        viewBinding.aotterPlayerView.visibility = View.GONE

        viewBinding.aotterWebView.visibility = View.GONE

        viewBinding.backgroundHolder.visibility = View.GONE

    }

    fun pause() {

        viewBinding.aotterPlayerView.pause()

        viewBinding.aotterWebView.pause()

    }

    fun resume() {

        viewBinding.aotterPlayerView.resume()

        viewBinding.aotterWebView.resume()

    }

    fun notifyCatrunImpressionOccurred() {

        viewBinding.aotterWebView.notifyCatrunImpressionOccurred()

    }

    private fun loadAotterPlayerView(trekNativeAd: TrekNativeAd) {

        viewBinding.aotterPlayerView.let { aotterPlayerView ->

            aotterPlayerView.layoutParams =
                LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT).apply {
                    bottomToBottom = ConstraintSet.PARENT_ID
                    endToEnd = ConstraintSet.PARENT_ID
                    startToStart = ConstraintSet.PARENT_ID
                    topToTop = ConstraintSet.PARENT_ID
                }

            aotterPlayerView.visibility = View.VISIBLE

            aotterPlayerView.setAotterPlayerViewListener(object :
                AotterPlayerView.AotterPlayerViewListener {
                override fun onVideoReady() {

                    viewBinding.backgroundHolder.animate().alpha(0f)?.duration = 300

                    trekMediaViewListener?.onLoaded(aotterPlayerView)

                }

            })

            aotterPlayerView.initialize(trekNativeAd, customTrekMediaViewListener)

        }

    }

    private fun loadAotterWebView(trekNativeAd: TrekNativeAd) {

        viewBinding.aotterWebView.let { aotterWebView ->

            aotterWebView.layoutParams =
                LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT).apply {
                    bottomToBottom = ConstraintSet.PARENT_ID
                    endToEnd = ConstraintSet.PARENT_ID
                    startToStart = ConstraintSet.PARENT_ID
                    topToTop = ConstraintSet.PARENT_ID
                }

            aotterWebView.visibility = View.VISIBLE

            aotterWebView.setAotterWebViewListener(object :
                AotterWebView.AotterWebViewListener {
                override fun onSendUrlClc(urlClcString: String) {
                    trekNativeAd.trekAdController?.getClickEvent(urlClcString)
                }

                override fun onPageLoaded() {

                    viewBinding.backgroundHolder.animate().alpha(0f)?.duration = 300

                    trekMediaViewListener?.onLoaded(aotterWebView)

                }

                override fun onClicked() {
                    trekNativeAd.trekAdListener?.onAdClicked()
                }

            })

            aotterWebView.loadAd(trekNativeAd)

        }

    }

    fun addFriendlyObstruction(view: View) {

        viewBinding.aotterPlayerView.addFriendlyObstructionView(view)

    }

    private fun initAnimatorListener() {

        viewBinding.backgroundHolder.animate().setListener(object : Animator.AnimatorListener {

            override fun onAnimationStart(animation: Animator) {
            }

            override fun onAnimationEnd(animation: Animator) {
                viewBinding.backgroundHolder.visibility = View.GONE
            }

            override fun onAnimationCancel(animation: Animator) {
            }

            override fun onAnimationRepeat(animation: Animator) {
            }

        })

    }

}