package com.aotter.net.trek.ads

import android.content.Context
import android.util.AttributeSet
import android.view.View
import com.aotter.net.dto.trek.response.TrekNativeAd
import com.aotter.net.trek.ads.base.TrekBaseView
import com.aotter.net.utils.TrekAdViewUtils
import com.aotter.net.utils.ViewStateTracker

class TrekNativeAdView : TrekBaseView {

    private var TAG: String = TrekNativeAdView::class.java.simpleName

    private var trekMediaView: TrekMediaView? = null

    private var trekNativeAd: TrekNativeAd? = null

    private var viewStateTracker: ViewStateTracker? = null

    constructor(context: Context) : super(context) {

    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {

    }

    constructor(context: Context, attrs: AttributeSet?, defStyle: Int) : super(
        context, attrs, defStyle
    ) {

    }

    fun setTrekMediaView(trekMediaView: TrekMediaView?) {

        this.trekMediaView = trekMediaView

    }


    fun setNativeAd(trekNativeAd: TrekNativeAd, friendlyObstructionViews: List<View> = listOf()) {

        destroy()

        this.trekNativeAd = trekNativeAd

        viewStateTracker = TrekAdViewUtils.createViewStateTracker(trekNativeAd).apply {

            friendlyObstructionViews.forEach { view ->

                this.addFriendlyObstruction(view)

            }

            this.launchViewStateTracker(this@TrekNativeAdView, trekMediaView)

        }

    }

    fun resume() {

        viewStateTracker?.resume()

    }

    fun pause() {

        viewStateTracker?.pause()

    }

    fun destroy() {

        this.trekNativeAd?.let {

            TrekAdViewUtils.destroyAd(it)

            viewStateTracker?.destroy()

            viewStateTracker = null

        }

    }

}