package com.aotter.net.trek.ads.base

import android.content.Context
import android.util.AttributeSet
import android.view.MotionEvent
import android.webkit.WebSettings
import android.webkit.WebView


open class BaseWebView : WebView {

    private var x1 = 0f
    private var x2 = 0f

    private var y1 = 0f
    private var y2 = 0f

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        init()
    }

    private fun init() {

        this.settings.let { it ->

            it.javaScriptEnabled = true //啟用js

            it.cacheMode = WebSettings.LOAD_NO_CACHE

            it.useWideViewPort = true //設定webview自適應螢幕大小

            it.layoutAlgorithm = WebSettings.LayoutAlgorithm.TEXT_AUTOSIZING

            it.loadWithOverviewMode = true //設定webview自適應螢幕大小

            it.defaultTextEncodingName = "UTF-8"

            it.mediaPlaybackRequiresUserGesture = false

        }

        isVerticalScrollBarEnabled = false; //去除上下滑动滾輪

        isHorizontalScrollBarEnabled = false;//去除左右滑动滾輪

        setInitialScale(100) //這個一般用來設定縮放比率

        setWebContentsDebuggingEnabled(true)

    }

    override fun onTouchEvent(event: MotionEvent): Boolean {

        when (event.action) {

            MotionEvent.ACTION_DOWN -> {
                x1 = event.x
                y1 = event.y

                this@BaseWebView
                    .requestDisallowInterceptTouchEvent(true)

            }

            MotionEvent.ACTION_MOVE -> {
                x2 = event.x
                y2 = event.y

                when {

                    x1 - x2 > 150 -> {

                        this@BaseWebView
                            .requestDisallowInterceptTouchEvent(false)

                    }

                    x2 - x1 > 150 -> {

                        this@BaseWebView
                            .requestDisallowInterceptTouchEvent(false)

                    }

                    y1 - y2 > 150 -> {

                        this@BaseWebView
                            .requestDisallowInterceptTouchEvent(false)

                    }

                    y2 - y1 > 150 -> {

                        this@BaseWebView
                            .requestDisallowInterceptTouchEvent(false)

                    }

                }

            }

        }

        return super.onTouchEvent(event)
    }


}