package com.aotter.net.trek.ads.controller.tracker

import com.aotter.net.dto.tracker.request.ReportTrackerBo
import com.aotter.net.dto.tracker.response.RecordDto
import com.aotter.net.model.repository.tracker.TrackerRepository
import com.aotter.net.network.Resource
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.launch

class TrackerController(
    private val trackerRepository: TrackerRepository
) {

    private val TAG: String = TrackerController::class.java.simpleName

    private var onTrackerRecordListener: OnTrackerRecordListener? = null

    private val scope: CoroutineScope by lazy {
        CoroutineScope(Dispatchers.Main + SupervisorJob())
    }

    interface OnTrackerRecordListener {

        fun onTrackerRecord(resource: Resource<RecordDto>) {}

    }

    fun setOnTrackerRecordListener(onTrackerRecordListener: OnTrackerRecordListener) {
        this.onTrackerRecordListener = onTrackerRecordListener
    }

    fun postTrackerRecord(reportTrackerBo: ReportTrackerBo) = scope.launch {

        trackerRepository.postTrackerRecord(
            reportTrackerBo
        ).onEach { resource ->

            onTrackerRecordListener?.onTrackerRecord(resource)

        }.launchIn(this)

    }

}
