package com.aotter.net.trek.ads.controller.trek

import com.aotter.net.dto.trek.request.AdBo
import com.aotter.net.dto.trek.response.TrekNativeAd
import com.aotter.net.model.repository.trek.TrekRepository
import com.aotter.net.network.Resource
import com.aotter.net.trek.ads.NativeAdOptions
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.SupervisorJob
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.combine
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.launch

class TrekAdController(
    private val trekRepository: TrekRepository
) {

    private val TAG: String = TrekAdController::class.java.simpleName

    interface OnTrekAdListener {

        fun onTrekAd(resource: Resource<TrekNativeAd>) {}

        fun onTrekAds(resources: List<Resource<TrekNativeAd>>) {}

    }

    private var nativeAdOptions: NativeAdOptions? = null



    private var onTrekAdListener: OnTrekAdListener? = null

    private val scope: CoroutineScope by lazy {
        CoroutineScope(Dispatchers.Main + SupervisorJob())
    }

    fun setNativeAdOptions(options: NativeAdOptions?) {
        this.nativeAdOptions = options
        trekRepository.setNativeAdOptions(options)
    }

    fun setOnTrekAdListener(onTrekAdListener: OnTrekAdListener) {
        this.onTrekAdListener = onTrekAdListener
    }

    fun init(adBo: AdBo) = scope.launch {
        trekRepository.init(adBo).catch { e ->
            // Handle the error here
        }.launchIn(this)
    }

    fun postAds(
        adBo: AdBo,
        maxNumberOfAds: Int
    ) = scope.launch {

        val postAdFlows = List(maxNumberOfAds) { trekRepository.postAd(adBo) }

        combine(postAdFlows) { result ->

            result.toList()

        }.onEach { results ->

            onTrekAdListener?.onTrekAds(results)

        }.launchIn(this)

    }


    fun postAd(adBo: AdBo) = scope.launch {

        trekRepository.postAd(adBo).onEach { resource ->

            onTrekAdListener?.onTrekAd(resource)

        }.launchIn(this)

    }

    fun getClickEvent(url: String) = scope.launch {

        trekRepository.getClickEvent(url).catch { e ->
            // Handle the error here
        }.launchIn(this)

    }

    fun getThirdPartyClickEvent(url: String) = scope.launch {

        trekRepository.getThirdPartyClickEvent(url).catch { e ->
            // Handle the error here
        }.launchIn(this)

    }

    fun getImpressionEvent(url: String) = scope.launch {

        trekRepository.getImpressionEvent(url).catch { e ->
            // Handle the error here
        }.launchIn(this)

    }

    fun getThirdPartyImpressionEvent(url: String) = scope.launch {

        trekRepository.getThirdPartyImpressionEvent(url).catch { e ->
            // Handle the error here
        }.launchIn(this)

    }


}