package com.aotter.net.trek.ads.vast

import android.content.Context
import android.media.AudioAttributes
import android.media.AudioFocusRequest
import android.media.AudioManager
import android.os.Build
import android.widget.ImageView
import androidx.core.content.ContextCompat
import androidx.media3.exoplayer.ExoPlayer

class AudioFocusChangeLoader(
    private val context: Context,
    private val player: ExoPlayer?,
    private val volumeImageView: ImageView
) : AudioManager.OnAudioFocusChangeListener {

    private var TAG: String = AudioFocusChangeLoader::class.java.simpleName

    private var audioManager: AudioManager =
        context.getSystemService(Context.AUDIO_SERVICE) as AudioManager

    private var audioAttributes: AudioAttributes? = null

    private var audioFocusRequest: AudioFocusRequest? = null

    private var focusRequest = -1

    override fun onAudioFocusChange(focusChange: Int) {

        when (focusChange) {

            AudioManager.AUDIOFOCUS_GAIN -> {

                setMuted(false)

            }
            AudioManager.AUDIOFOCUS_GAIN_TRANSIENT -> {

                setMuted(false)

            }
            AudioManager.AUDIOFOCUS_LOSS_TRANSIENT -> {

                setMuted(true)

            }
            AudioManager.AUDIOFOCUS_LOSS -> {

                //這邊的CallBack代表第三方的app請求的是長時間焦點,且不會再回調AUDIOFOCUS_GAIN恢復
                //如果要恢復播放必須使用者有明確的操作
                //ex.按下播放扭

                setMuted(true)


            }

        }

    }

    init {

        initializeAbandonAudioFocus()

    }

    private fun initializeAbandonAudioFocus() {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            audioAttributes = AudioAttributes.Builder()
                .setUsage(AudioAttributes.USAGE_MEDIA)
                .setContentType(AudioAttributes.CONTENT_TYPE_MUSIC).build()
                .apply {

                    audioFocusRequest =
                        AudioFocusRequest.Builder(AudioManager.AUDIOFOCUS_GAIN_TRANSIENT)
                            .setAudioAttributes(this).setAcceptsDelayedFocusGain(true)
                            .setOnAudioFocusChangeListener(this@AudioFocusChangeLoader).build()

                }

        }

        setMuted(true)

    }

    fun setMuted(isMute: Boolean) {

        if (!isMute) {

            volumeImageView.setImageDrawable(
                ContextCompat.getDrawable(
                    context, android.R.drawable.ic_lock_silent_mode_off
                )
            )

            player?.volume = 1.0f

        } else {

            volumeImageView.setImageDrawable(
                ContextCompat.getDrawable(
                    context, android.R.drawable.ic_lock_silent_mode
                )
            )

            player?.volume = 0f

        }

    }

    fun requestAudioFocus() {

        focusRequest = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            audioFocusRequest?.let {
                audioManager.requestAudioFocus(it)
            } ?: kotlin.run {
                -1
            }

        } else {

            audioManager.requestAudioFocus(
                this, AudioManager.STREAM_MUSIC, AudioManager.AUDIOFOCUS_GAIN_TRANSIENT
            )

        }

        when (focusRequest) {

            AudioManager.AUDIOFOCUS_REQUEST_GRANTED -> {

                setMuted(false)

            }

        }

    }


    fun releaseAbandonAudioFocus() {

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {

            audioFocusRequest?.let {

                audioManager.abandonAudioFocusRequest(it)

            }

        } else {
            audioManager.abandonAudioFocus(this)
        }

        setMuted(true)

    }

    fun destroy() {

        releaseAbandonAudioFocus()

        audioAttributes = null

        audioFocusRequest = null

    }

}