package com.aotter.net.trek.ads.webview

import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.os.Bundle
import android.view.*
import androidx.fragment.app.DialogFragment
import androidx.fragment.app.FragmentManager
import com.aotter.net.databinding.FragmentDialogPopupWebviewBinding


class PopupWebViewDialogFragment : DialogFragment() {

    private lateinit var viewBinding: FragmentDialogPopupWebviewBinding


    companion object{

        private const val URL = "Url"

        fun newInstance(urlString: String): PopupWebViewDialogFragment {

            val fragment = PopupWebViewDialogFragment()

            val args = Bundle()

            args.putString(URL, urlString)

            fragment.arguments = args

            return fragment

        }

    }



    override fun onStart() {
        super.onStart()

        dialog?.window?.let {

            it.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))

            val windowParams = it.attributes

            windowParams.dimAmount = 0.3f

            //去掉默認padding
//            it.decorView.setPadding(0, 0, 0, 0)

            windowParams.width = WindowManager.LayoutParams.WRAP_CONTENT

            windowParams.height = WindowManager.LayoutParams.WRAP_CONTENT

            windowParams.gravity = Gravity.CENTER

            it.attributes = windowParams

        }

    }


    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {

        dialog?.requestWindowFeature(Window.FEATURE_NO_TITLE)

        viewBinding = FragmentDialogPopupWebviewBinding.inflate(inflater, container, false)

        return viewBinding.root

    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        initView()

        arguments?.getString(URL)?.let { urlString ->

            viewBinding.popupWebView.loadUrlAd(urlString)

        }

    }

    private fun initView() {

        viewBinding.closePopupWebViewBtn.setOnClickListener {

            this.dismissAllowingStateLoss()

        }

    }

    override fun show(manager: FragmentManager, tag: String?) {
        // super.show(manager, tag)
        val fragment = manager.beginTransaction()
        fragment.remove(this)
        fragment.add(this, tag)
        fragment.commitAllowingStateLoss()
    }

}