package com.aotter.net.trek.ads.webview

import android.content.Context
import android.webkit.WebView
import com.aotter.net.trek.sensors.Accelerometer
import com.aotter.net.trek.sensors.Gyroscope

class SensorsLoader(private val context: Context, private val webView: WebView) {

    private var gyroscope: Gyroscope? = null

    private var accelerometer: Accelerometer? = null

    fun initAccelerometer() {

        accelerometer?.unregister()

        accelerometer = Accelerometer(context)

        accelerometer?.setAccelerometerListener(object : Accelerometer.AccelerometerListener {

            override fun onTranslation(tx: Float, ty: Float, tz: Float) {

                webView.evaluateJavascript("javascript:window.WebViewBridge.emit('ACCELEROMETER', { payload: {x: $tx, y: $ty, z: $tz} })") {}

            }

        })

    }

    fun initGyroscope() {

        gyroscope?.unregister()

        gyroscope = Gyroscope(context)

        gyroscope?.setGyroscopeListener(object : Gyroscope.GyroscopeListener {

            override fun onRotation(tx: Float, ty: Float, tz: Float) {

                webView.evaluateJavascript("javascript:window.WebViewBridge.emit('GYROSCOPE', { payload: {x: $tx, y: $ty, z: $tz} })") {}

            }

        })

    }

    fun register() {

        gyroscope?.register()

        accelerometer?.register()

    }

    fun unregister() {

        gyroscope?.unregister()

        accelerometer?.unregister()

    }

    fun destroy() {

        unregister()

        gyroscope = null

        accelerometer = null

    }

}