package com.aotter.net.trek.om

import android.util.Log
import android.view.View
import android.webkit.WebView
import com.aotter.net.dto.OmVerificationScriptResource
import com.iab.omid.library.aotternet.adsession.*
import java.net.URL

class TrekOmFactory {

    companion object {

        private const val IAB_TECH_LAB_COM_OMID = "iabtechlab.com-omid"

        private const val IAB_TECH_LAB_AOTTER_NET = "iabtechlab-Aotternet"

    }

    private var TAG: String = TrekOmFactory::class.java.simpleName

    private var adSession: AdSession? = null

    private var adEvents: AdEvents? = null

    private var contentUrl: String = ""

    private var customReferenceData: String = ""

    fun addFriendlyObstruction(view: View) {

        adSession?.let {

            it.addFriendlyObstruction(view, FriendlyObstructionPurpose.NOT_VISIBLE, null)

            Log.i(TAG, "add view id: ${view.id} as friendly obstruction.")

        }

    }

    fun removeAllFriendlyObstructions() {

        adSession?.let {

            it.removeAllFriendlyObstructions()

            Log.i(TAG, "remove all friendly obstructions.")

        }

    }

    fun setContentUrl(contentUrl: String) {

        this.contentUrl = contentUrl

    }

    fun setCustomReferenceData(customReferenceData: String) {

        this.customReferenceData = customReferenceData

    }

    fun initNativeAdSession(
        omRes: List<OmVerificationScriptResource>?
    ) {

        try {

            adSession?.let {
                stopAdSession()
            }

            if (omRes.isNullOrEmpty()) return

            val verificationScriptResourceList = mutableListOf<VerificationScriptResource>()

            omRes.forEach { omVerificationScriptResource ->

                val verificationScriptResource =
                    VerificationScriptResource.createVerificationScriptResourceWithParameters(
                        omVerificationScriptResource.vendorKey,
                        URL(omVerificationScriptResource.javascriptResourceUrl),
                        omVerificationScriptResource.verificationParameters
                    )

                verificationScriptResourceList.add(verificationScriptResource)

            }

            val adSessionContext = AdSessionContext.createNativeAdSessionContext(
                TrekOmLauncher.getTrekPartner(),
                TrekOmLauncher.getOmServiceContent(),
                verificationScriptResourceList,
                contentUrl,
                customReferenceData
            )

            val adSessionConfiguration =
                AdSessionConfiguration.createAdSessionConfiguration(
                    CreativeType.NATIVE_DISPLAY, ImpressionType.VIEWABLE,
                    Owner.NATIVE, Owner.NONE, false
                )

            adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext)

        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }

    }

    fun registerAdView(adView: View) {

        try {

            adSession?.registerAdView(adView)

        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }

    }

    fun startAdSession() {

        try {

            adSession?.start()

        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }

    }

    fun loadedAdEvents() {

        try {

            adSession?.let {

                adEvents = AdEvents.createAdEvents(it).apply {
                    loaded()
                }

            }

        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }

    }

    fun initHtmlAdSession(
        webView: WebView,
        omRes: List<OmVerificationScriptResource>?
    ) {

        try {

            adSession?.let {
                stopAdSession()
            }

            if (omRes.isNullOrEmpty()) return

            val verificationScriptResourceList = mutableListOf<VerificationScriptResource>()

            omRes.forEach { omVerificationScriptResource ->

                val verificationScriptResource =
                    VerificationScriptResource.createVerificationScriptResourceWithParameters(
                        omVerificationScriptResource.vendorKey,
                        URL(omVerificationScriptResource.javascriptResourceUrl),
                        omVerificationScriptResource.verificationParameters
                    )

                verificationScriptResourceList.add(verificationScriptResource)

            }

            val adSessionContext = AdSessionContext.createHtmlAdSessionContext(
                TrekOmLauncher.getTrekPartner(),
                webView,
                contentUrl,
                customReferenceData
            )

            val adSessionConfiguration =
                AdSessionConfiguration.createAdSessionConfiguration(
                    CreativeType.HTML_DISPLAY, ImpressionType.VIEWABLE,
                    Owner.NATIVE, Owner.NONE, false
                )

            adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext).apply {
                registerAdView(webView)
                start()
                adEvents = AdEvents.createAdEvents(this).apply {
                    loaded()
                }
            }

        } catch (e: Exception) {
            Log.e(TAG, e.toString())
        }

    }

    fun fireImpression() {

        adSession?.let {

            try {

                adEvents?.let {

                    it.impressionOccurred()

                    Log.i(TAG, "OM impression Occurred.")

                }

            } catch (e: Exception) {

                Log.e(TAG, e.toString())

            }

        }

    }

    fun stopAdSession() {

        adSession?.finish()

        adSession = null

    }

}