package com.aotter.net.trek.om

import android.content.Context
import android.util.Log
import com.aotter.net.utils.TrekSdkSettingsUtils
import com.iab.omid.library.aotternet.Omid
import com.iab.omid.library.aotternet.adsession.Partner
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.io.BufferedReader
import java.io.IOException
import java.net.URL

object TrekOmLauncher {

    private val TAG: String = TrekOmLauncher::class.java.simpleName

    private var omServiceContent = ""

    private var trekPartner: Partner? = null

    private const val OMID_PARTNER_NAME = "Aotternet"

    private const val OMID_JS = "https://static.aottercdn.com/trek/om/omsdk-v1.js"

    fun activateOm(context: Context) {

        try {

            if (!Omid.isActive()) {

                Omid.activate(context)
                createPartner()
                loadOmJS(URL(OMID_JS))
                Log.i(TAG, "Activate OM finished.")
            }

        } catch (e: IllegalArgumentException) {
            Log.e(TAG, e.toString())
        }

    }

    private fun createPartner() {
        trekPartner =
            Partner.createPartner(OMID_PARTNER_NAME, TrekSdkSettingsUtils.SDK_VERSION)
        Log.i(TAG, "OM partner created.")
    }

    private fun loadOmJS(url: URL) {

        CoroutineScope(Dispatchers.IO).launch {

            try {

                withContext(Dispatchers.IO) {
                    url.openStream()
                }.use { stream ->

                    val response = BufferedReader(stream.reader()).use { reader ->
                        reader.readText()
                    }

                    omServiceContent = response

                    Log.i(TAG, "OM service content loaded : \n $omServiceContent")

                }

            } catch (e: IOException) {

                Log.e(TAG, e.toString())

            }

        }

    }

    fun getTrekPartner() = trekPartner

    fun getOmServiceContent() = omServiceContent

}