package com.aotter.net.trek.sensors

import android.content.Context
import android.hardware.Sensor
import android.hardware.SensorEvent
import android.hardware.SensorEventListener
import android.hardware.SensorManager


class Accelerometer(private val context: Context) {

    interface AccelerometerListener {

        fun onTranslation(tx: Float, ty: Float, tz: Float)

    }

    private var accelerometerListener: AccelerometerListener? = null

    private var sensorManager: SensorManager? = null

    private var sensor: Sensor? = null

    private var sensorEventListener: SensorEventListener? = null

    init {

        sensorManager = context.getSystemService(Context.SENSOR_SERVICE) as SensorManager

        sensor = sensorManager?.getDefaultSensor(Sensor.TYPE_ACCELEROMETER)

        sensorEventListener = object : SensorEventListener {

            override fun onSensorChanged(event: SensorEvent) {

                if (event.sensor.type != Sensor.TYPE_ACCELEROMETER) return

                accelerometerListener?.onTranslation(
                        "%.2f".format(event.values[0]).toFloat(),
                        "%.2f".format(event.values[1]).toFloat(),
                        "%.2f".format(event.values[2]).toFloat()
                )

            }

            override fun onAccuracyChanged(sensor: Sensor?, accuracy: Int) {

            }

        }

    }

    fun setAccelerometerListener(accelerometerListener: AccelerometerListener) {

        this.accelerometerListener = accelerometerListener

    }

    fun register() {

        sensorManager?.registerListener(
                sensorEventListener,
                sensor,
                SensorManager.SENSOR_DELAY_NORMAL
        )

    }


    fun unregister() {

        sensorManager?.unregisterListener(sensorEventListener)

    }

}