package com.aotter.net.trek.sensors

import android.content.Context
import android.hardware.Sensor
import android.hardware.SensorEvent
import android.hardware.SensorEventListener

import android.hardware.SensorManager


class Gyroscope(private val context: Context) {

    private var sensorManager: SensorManager? = null
    private var sensor: Sensor? = null
    private var sensorEventListener: SensorEventListener? = null

    interface GyroscopeListener {

        fun onRotation(tx: Float, ty: Float, tz: Float)

    }

    private var gyroscopeListener: GyroscopeListener? = null

    fun setGyroscopeListener(gyroscopeListener: GyroscopeListener) {

        this.gyroscopeListener = gyroscopeListener

    }

    init {

        sensorManager = context.getSystemService(Context.SENSOR_SERVICE) as SensorManager

        sensor = sensorManager?.getDefaultSensor(Sensor.TYPE_GYROSCOPE)

        sensorEventListener = object : SensorEventListener {

            override fun onSensorChanged(event: SensorEvent) {

                if (event.sensor.type != Sensor.TYPE_GYROSCOPE) return

                gyroscopeListener?.onRotation(
                    "%.2f".format(event.values[0]).toFloat(),
                    "%.2f".format(event.values[1]).toFloat(),
                    "%.2f".format(event.values[2]).toFloat()
                )

            }

            override fun onAccuracyChanged(sensor: Sensor?, accuracy: Int) {

            }

        }

    }

    fun register() {

        sensorManager?.registerListener(
            sensorEventListener,
            sensor,
            SensorManager.SENSOR_DELAY_NORMAL
        )
    }

    fun unregister() {

        sensorManager?.unregisterListener(sensorEventListener)

    }

}