package com.aotter.net.trek.tracker

import android.content.Context
import com.aotter.net.dto.Entity
import com.aotter.net.dto.Location
import com.aotter.net.dto.User
import com.aotter.net.dto.tracker.request.ReportTrackerBo
import com.aotter.net.model.repository.tracker.TrackerRepository
import com.aotter.net.network.RetrofitBuilder
import com.aotter.net.trek.TrekDataKey
import com.aotter.net.trek.ads.controller.tracker.TrackerController
import com.aotter.net.trek.sealed.ActionType
import com.aotter.net.utils.DeviceUtils
import com.aotter.net.utils.TrekSdkSettingsUtils
import com.aotter.net.utils.UserInfoUtils


class Tracker(private val context: Context) {

    private var entity: Entity? = null

    private var actionType: String = ""

    private var location: Location? = null

    private var userInfo: User? = null

    private var timespan: Int = 0

    private var trackerController: TrackerController = TrackerController(
        trackerRepository = TrackerRepository(
            RetrofitBuilder.createTrackerService()
        )
    )

    companion object {

        private const val ENTITY_NULL_ERROR = "The entity object is required."

        private const val USER_NULL_ERROR = "The user object is required."

    }


    fun setEntity(entity: Entity): Tracker {

        this.entity = entity

        return this

    }

    fun setLocation(location: Location?): Tracker {

        this.location = location

        return this

    }

    fun timeSpan(timeSpan: Int): Tracker {

        this.timespan = timeSpan

        return this

    }

    fun setActionType(actionType: ActionType): Tracker {

        this.actionType = actionType.action

        return this

    }

    fun setActionType(actionType: String): Tracker {

        this.actionType = actionType

        return this

    }

    fun setUser(userInfo: User): Tracker {

        UserInfoUtils.setTrackerUserInfo(userInfo)

        this.userInfo = UserInfoUtils.getTrackerUserInfo()

        return this

    }

    fun sendTrackerReport() {

        if (TrekSdkSettingsUtils.getClientId().isEmpty()) {

            throw IllegalArgumentException(TrekDataKey.INITIALIZED_INCORRECTLY)

        }

        val reportTrackerBo = ReportTrackerBo(
            "${TrekSdkSettingsUtils.OS}_${TrekSdkSettingsUtils.SDK_VERSION}",
            timespan,
            actionType,
            DeviceUtils.getDevice(),
            entity ?: throw NullPointerException(ENTITY_NULL_ERROR),
            location,
            userInfo ?: throw NullPointerException(USER_NULL_ERROR)
        )

        trackerController.postTrackerRecord(reportTrackerBo)

    }

}