package com.aotter.net.utils

import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build

object AppInfoUtils {

    private lateinit var packageInfo: PackageInfo

    private lateinit var appId: String
    private lateinit var appVersion: String

    fun init(context: Context) {

        appId = context.packageName

        packageInfo = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            context.packageManager.getPackageInfo(
                appId,
                PackageManager.PackageInfoFlags.of(0)
            )
        } else {
            context.packageManager.getPackageInfo(appId, 0)
        }

        val version = packageInfo.versionName

        val code = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P) {
            packageInfo.longVersionCode
        } else {
            packageInfo.versionCode
        }

        appVersion = "$version($code)"

    }

    fun getAppId(): String {
        return appId
    }

    fun getAppVersion(): String {
        return appVersion
    }

}