package com.aotter.net.utils

import com.aotter.net.BuildConfig
import com.aotter.net.controller.error.ErrorReportController
import com.aotter.net.dto.error.request.ErrorReport
import com.aotter.net.dto.trek.request.AdBo
import com.aotter.net.dto.trek.response.TrekNativeAdDto
import com.aotter.net.model.repository.error.ErrorReportRepository
import com.aotter.net.network.RetrofitBuilder

object ErrorReportUtils {

    private const val PATH_POST_AD = "${BuildConfig.MFTC_URL}/api/v2/fetch"

    private var errorReportController = ErrorReportController(
        errorReportRepository = ErrorReportRepository(
            RetrofitBuilder.createTrekErrorService()
        )
    )

    fun sendFetchAdError(errorReport: ErrorReport<AdBo, TrekNativeAdDto>) {

        errorReport.requestFullPath = PATH_POST_AD
        errorReportController.postError(errorReport)

    }

}