package com.aotter.net.utils

import android.content.Context
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.runBlocking

object PreferencesDataStoreUtils {

    private const val TREK_APPLICATION = "TrekApplication"

    private val Context.applicationPreferencesDataStore by preferencesDataStore(name = TREK_APPLICATION)

    private val AD_ID_KEY = stringPreferencesKey("AdId")

    private val EIDS_KEY = stringPreferencesKey("Eids")

    private val HASH_EMAIL = stringPreferencesKey("HashEmail")
    private val HASH_PHONE = stringPreferencesKey("HashPhone")

    suspend fun setAdId(context: Context, newAdId: String) {

        context.applicationPreferencesDataStore.edit { settings ->

            val oldAdId = settings[AD_ID_KEY] ?: ""

            if (oldAdId == newAdId) return@edit

            settings[AD_ID_KEY] = newAdId

        }

    }


    fun getAdId(context: Context): String = runBlocking {

        context.applicationPreferencesDataStore.data.first()[AD_ID_KEY] ?: ""

    }

    suspend fun setHashEmail(context: Context, hashEmail: String) {

        context.applicationPreferencesDataStore.edit { settings ->

            val oldValue = settings[HASH_EMAIL] ?: ""

            if (oldValue == hashEmail) return@edit

            settings[HASH_EMAIL] = hashEmail

        }

    }

    fun getHashEmail(context: Context): String = runBlocking {

        context.applicationPreferencesDataStore.data.first()[HASH_EMAIL] ?: ""

    }

    suspend fun setHashPhone(context: Context, hashPhone: String) {

        context.applicationPreferencesDataStore.edit { settings ->

            val oldValue = settings[HASH_PHONE] ?: ""

            if (oldValue == hashPhone) return@edit

            settings[HASH_PHONE] = hashPhone

        }

    }

    fun getHashPhone(context: Context): String = runBlocking {

        context.applicationPreferencesDataStore.data.first()[HASH_PHONE] ?: ""

    }

    suspend fun clearSavedHashData(context: Context) {

        context.applicationPreferencesDataStore.edit { settings ->

            settings[HASH_EMAIL] = ""
            settings[HASH_PHONE] = ""
            settings[EIDS_KEY] = ""

        }

    }

    suspend fun setUserEids(context: Context, eids: String) {

        context.applicationPreferencesDataStore.edit { settings ->

            val oldValue = settings[EIDS_KEY] ?: ""

            if (oldValue == eids) return@edit

            settings[EIDS_KEY] = eids

        }

    }

    suspend fun getHashEids(context: Context): String? {
        return context.applicationPreferencesDataStore.data.first()[EIDS_KEY]
    }
}
