package com.aotter.net.utils

import android.util.Log
import com.aotter.net.dto.trek.response.TrekNativeAd
import java.util.concurrent.ConcurrentHashMap

object TrekAdViewUtils {

    private val TAG: String = TrekAdViewUtils::class.java.simpleName

    private val concurrentHashMap = ConcurrentHashMap<String, ViewStateTracker>()

    fun createViewStateTracker(
        trekNativeAd: TrekNativeAd
    ): ViewStateTracker {

        val viewStateTracker = ViewStateTracker(trekNativeAd)

        concurrentHashMap[trekNativeAd.unitInstanceId] = viewStateTracker

        Log.i(TAG, "Current count of viewStateTracker: ${concurrentHashMap.count()}")

        return viewStateTracker

    }

    fun destroyAd(trekNativeAd: TrekNativeAd) {

        try {

            concurrentHashMap[trekNativeAd.unitInstanceId]?.let { viewStateTracker ->

                viewStateTracker.destroy()

                concurrentHashMap.remove(trekNativeAd.unitInstanceId)

            }

            Log.i(
                TAG,
                "Destroy ad success. Current count of viewStateTracker: ${concurrentHashMap.count()}"
            )

        } catch (e: Exception) {

            Log.e(TAG, e.toString())

        }

    }

}
