package com.aotter.net.utils

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.Drawable
import android.net.Uri
import android.util.LruCache
import android.webkit.WebSettings
import com.aotter.net.BuildConfig
import com.aotter.net.extension.memoryCacheSizeBytes
import kotlinx.serialization.json.Json


object TrekSdkSettingsUtils {

    val json = Json {
        isLenient = true
        ignoreUnknownKeys = true
    }

    const val SDK_VERSION_CODE = BuildConfig.SDK_VERSION_CODE

    const val SDK_VERSION = BuildConfig.SDK_VERSION

    const val OS = BuildConfig.OS

    private var clientId: String = ""

    private var defaultUserAgent: String = ""

    var ATSSPDomain: String = ""
        private set
    var ATSSPPathFetchAd: String = ""
        private set
    var ATSSPEIDsAPIDomain: String = ""
        private set
    var ATSSPPathEIDsAPIGenerate: String = ""
        private set
    var ATSSPPathEIDsAPIRefresh: String = ""
        private set
    var ATTrackerDomain: String = ""
        private set
    var ATTrackerPathReport: String = ""
        private set

    fun updateSettings(
        ATSSPDomain: String? = null,
        ATSSPPathFetchAd: String? = null,
        ATSSPEIDsAPIDomain: String? = null,
        ATSSPPathEIDsAPIGenerate: String? = null,
        ATSSPPathEIDsAPIRefresh: String? = null,
        ATTrackerDomain: String? = null,
        ATTrackerPathReport: String? = null
    ) {
        ATSSPDomain?.let { this.ATSSPDomain = it }
        ATSSPPathFetchAd?.let { this.ATSSPPathFetchAd = it }
        ATSSPEIDsAPIDomain?.let { this.ATSSPEIDsAPIDomain = it }
        ATSSPPathEIDsAPIGenerate?.let { this.ATSSPPathEIDsAPIGenerate = it }
        ATSSPPathEIDsAPIRefresh?.let { this.ATSSPPathEIDsAPIRefresh = it }
        ATTrackerDomain?.let { this.ATTrackerDomain = it }
        ATTrackerPathReport?.let { this.ATTrackerPathReport = it }
    }

    fun getDefaultUserAgent() = defaultUserAgent

    fun setDefaultUserAgent(context: Context) {

        defaultUserAgent = WebSettings.getDefaultUserAgent(context.applicationContext)

    }

    fun getClientId() = clientId

    fun setClientId(clientId: String?) {

        TrekSdkSettingsUtils.clientId = clientId ?: ""

    }

    private lateinit var imageCache: LruCache<String, Bitmap>

    private lateinit var unitInstanceIdCache: LruCache<String, String>

    fun initImageCache(context: Context) {
        imageCache = object : LruCache<String, Bitmap>(context.memoryCacheSizeBytes()) {

            override fun sizeOf(key: String, value: Bitmap): Int {

                return value.let {
                    it.rowBytes * it.height
                }

            }

        }
    }

    fun initUnitInstanceIdCache(context: Context) {
        unitInstanceIdCache = LruCache<String, String>(context.memoryCacheSizeBytes())
    }

    fun getImageCache() = imageCache

    fun getUnitInstanceIdCache(): LruCache<String, String> {
        if (!::unitInstanceIdCache.isInitialized) {
            // Create a default cache if not initialized
            unitInstanceIdCache = LruCache(5 * 1024 * 1024)
        }
        return unitInstanceIdCache
    }

    fun setImageCache(urlKey: String, bitmap: Bitmap) {
        imageCache.put(urlKey, bitmap)
    }

    fun setUnitInstanceIdCache(unitInstanceId: String) {
        unitInstanceIdCache.put(unitInstanceId, unitInstanceId)
    }

    //開啟外部瀏覽器
    fun openBrowser(context: Context, url: String) {

        try {

            //開啟 chrome 瀏覽器
            val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TOP
            intent.setClassName("com.android.chrome", "com.google.android.apps.chrome.Main")
            context.startActivity(intent)

        } catch (e: Exception) {

            //開啟 手機預設 瀏覽器
            val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TOP
            context.startActivity(intent)

        }

    }

    fun getBitmapDrawable(context: Context?, bitmap: Bitmap): Drawable? {

        return context?.let {
            BitmapDrawable(
                context.resources, bitmap
            )
        } ?: kotlin.run {
            null
        }

    }


}