package com.aotter.trek.impression

import android.util.Log
import android.view.View
import kotlinx.coroutines.*

class ImpressionCountDownTimer(
    private val view: View,
    private var impressionRequest: ImpressionRequest,
    private var impressionListener: ImpressionListener?,
    private var viewStateTracker: ImpressionListener?
) {

    private var impressionJob = CoroutineScope(Dispatchers.IO + Job())

    fun sendViewRatio(ratio: Double) {

        impressionListener?.onRatio(ratio)

    }

    fun checkPercent(percent: Int) {

        impressionListener?.onVisibleRangePercent((percent.toDouble() / 100))

        impressionJob.launch {

            this.ensureActive() // Check for cancellation

            val startPercent = impressionRequest.getVisibleRangePercent()

            val millisInFuture = impressionRequest.getMillisInFuture()

            if (percent >= startPercent) {

                delay(millisInFuture)

                launch(Dispatchers.Main) {

                    this.ensureActive() // Check for cancellation

                    impressionListener?.onImpression(view)
                    viewStateTracker?.onImpression(view)

                    impressionJob.cancel()

                }.join()

            } else {

                impressionJob.cancel()

                impressionJob = CoroutineScope(Dispatchers.IO + Job())

            }

        }

    }

    fun pause() {

        impressionJob.cancel()

        impressionJob = CoroutineScope(Dispatchers.IO + Job())

    }

    fun destroy() {

        impressionJob.cancel()

    }

}